//-----------------------------------------------------------------------------

// Variables used by client scripts & code.  The ones marked with (c)
// are accessed from code.  Variables preceeded by Pref:: are client
// preferences and stored automatically in the ~/client/prefs.cs file
// in between sessions.
//
//    (c) Client::MissionFile             Mission file name
//    ( ) Client::Password                Password for server join

//    (?) Pref::Player::CurrentFOV
//    (?) Pref::Player::DefaultFov
//    ( ) Pref::Input::KeyboardTurnSpeed

//    (c) pref::Master[n]                 List of master servers
//    (c) pref::Net::RegionMask     
//    (c) pref::Client::ServerFavoriteCount
//    (c) pref::Client::ServerFavorite[FavoriteCount]
//    .. Many more prefs... need to finish this off

// Moves, not finished with this either...
//    (c) firstPerson
//    $mv*Action...

//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------

function initClient()
{
   echo("\n--------- Initializing Westward II: Client ---------");
   //$WaterAnimSpeed  = 300;

   // Make sure this variable reflects the correct state.
   $Server::Dedicated = false;

   // Game information used to query the master server
   $Client::GameTypeQuery = "Westward 2";
   $Client::MissionTypeQuery = "Any";

   /// Load client-side Audio Profiles/Descriptions
   exec("./scripts/audioProfiles.cs");
   
   //
   exec("./ui/customProfiles.cs"); // override the base profiles if necessary
   
   // The common module provides basic client functionality
   initBaseClient();

   // InitCanvas starts up the graphics system.
   // The canvas needs to be constructed before the gui scripts are
   // run because many of the controls assume the canvas exists at
   // load time.
   initCanvas("Westward 2", true);
   if (!isObject(Canvas))
      // failed, don't make it worse by crashing...
      return;

   // Load up the initial game GUIs
   exec("./ui/defaultGameProfiles.cs");
   exec("./ui/loadingGui.gui");
   exec("./ui/splashGui.gui");
   
  // AFX (only needed for TGE1.4 + TLK
  // if (!afxLegacyLighting())
  // {
  //    if (isFile("common/synapseGaming/contentPacks/lightingPack/sgDeployClient.cs"))
  //    {
  //      echo("Initializing TLK Client support");
  //      exec("common/synapseGaming/contentPacks/lightingPack/sgDeployClient.cs");
  //     }
  //  }
   // AFX

   // Client scripts
   exec("./scripts/missionDownload.cs");
   exec("./scripts/serverConnection.cs");
   exec("./scripts/loadingGui.cs");
   exec("./scripts/client_splash.cs");

   // Default player key bindings
   exec("./scripts/default.bind.cs");
   //  exec("./config.cs"); // AFX

   // Really shouldn't be starting the networking unless we are
   // going to connect to a remote server, or host a multi-player
   // game.
   setNetPort(0);

   // Copy saved script prefs into C++ code.
   setShadowDetailLevel( $pref::shadows );
   setDefaultFov( $pref::Player::defaultFov );
   setZoomSpeed( $pref::Player::zoomSpeed );

   // Start up the main menu... this is separated out into a 
   // method for easier mod override.

   // this is commented out because we do not want anyone directly
   // connecting to the menu without loading the datablocks first
   // (instead, use the loadSplash() call to propagate to the menu)
   /*
   if ($JoinGameAddress !$= "") {
      // If we are instantly connecting to an address, load the
      // main menu then attempt the connect.
      loadMainMenu();
      connect($JoinGameAddress, "", $Pref::Player::Name);
   }
   else {
      // Otherwise go to the splash screen.
      Canvas.setCursor("DefaultCursor");
      loadSplash();
   }
   */

   // load the splash sequence
   Canvas.setCursor("DefaultCursor");
   loadSplash();
}


//-----------------------------------------------------------------------------
